<?php

if ( !class_exists('parlo_currency_widgets') ) {
    class parlo_currency_widgets extends WP_Widget{

        function __construct(){

            $widget_options = array(
                'description'                   => esc_html__('Parlo Currency', 'parlo'), 
                'customize_selective_refresh'   => true,
            );

            parent:: __construct('parlo_currency_widgets', esc_html__( 'Parlo:: Currency', 'parlo'), $widget_options );

        }
        /**
         * Front-end display of widget.
         *
         * @see WP_Widget::widget()
         *
         * @param array $args     Widget arguments.
         * @param array $instance Saved values from database.
         */
        public function widget($args, $instance){ 

            $title = isset( $instance['title'] ) ? $instance['title'] : '';
            
            // Render Html
            echo $args['before_widget'];
                if ( !empty( $title ) ) { echo $args['before_title'] . esc_html( $title ) . $args['after_title']; }
            ?>
                <div class="parlo-currency-widget">
                    <?php parlo_currency_dropdown(); ?>
                </div>
            <?php echo $args['after_widget']; 
        }


        /**
         * Sanitize widget form values as they are saved.
         *
         * @see WP_Widget::update()
         *
         * @param array $new_instance Values just sent to be saved.
         * @param array $old_instance Previously saved values from database.
         *
         * @return array Updated safe values to be saved.
         */

        public function update( $new_instance, $old_instance ) {
            $instance = $old_instance;  
            $instance['title']              =  strip_tags($new_instance['title']);                             
            return $instance;
        }

        /**
         * Back-end widget form.
         *
         * @see WP_Widget::form()
         *
         * @param array $instance Previously saved values from database.
         */

        public function form( $instance ){ 

            $array_default = array(
                'title'    => 'Currency'
            );
            $instance = wp_parse_args( (array) $instance, $array_default );

            ?>

            <p>
                <label for="<?php echo $this->get_field_id('title'); ?>"><?php esc_html_e('Enter your title', 'parlo'); ?> </label>
                <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo esc_attr($instance['title']); ?>" />
            </p>

        <?php }

    } // end extends class
} // end exists class


// Register Currency widget.
function parlo_currency_widgets() {
    register_widget( 'parlo_currency_widgets' );
}
add_action( 'widgets_init', 'parlo_currency_widgets' );