<?php

/**
 * Custom Walker
 *
 * @access      public
 * @since       1.0 
 * @return      void
*/

class parlo_Nav_Walker extends Walker_Nav_Menu

{
  public $parlo_Mega ='';
  public $megadiv ='';
  public $parlo_CLM ='';
  public $parlo_scode = '';
  public $parlo_menupos = '';

  public function start_lvl( &$output,  $depth = 0, $args = array() ) {
	$Mlas ='';
    $indent = str_repeat("\t", $depth);
    if( $depth === 0 &&  $this->parlo_Mega == "yes"){
      if($this->parlo_CLM=='50%'){
        $Mwd = '500px';
		$Mlas = 'second';
      }elseif($this->parlo_CLM=='33%'){
        $Mwd = '700px';
        $Mlas = 'third';
      }elseif($this->parlo_CLM=='25%'){
        $Mwd = '970px';
        $Mlas = 'fourth';
      }else{
        $Mwd = '';
      }

      $output .= "\n$indent<ul class=\"mega-menu-ul $Mlas\" style=\"width:$Mwd;left:$this->parlo_menupos;\">\n";
    }else{
      $output .= "\n$indent<ul class=\"sub-menu\">\n";
    }
  }

  function start_el(&$output, $item, $depth = 0, $args = array(), $id = 0) {
     global $wp_query;
     $indent = ( $depth ) ? str_repeat( "\t", $depth ) : '';
    if($item->megamenu == 'enabled'){
      $this->parlo_Mega = 'yes';
    }else{
      $this->parlo_Mega = 'no';
    }

    if($depth === 0 && $this->parlo_Mega=='no'){
      $parlo_cls = 'nocls';
    }else{
      $parlo_cls = '';
    }

     $class_names = $value = '';
     $classes = empty( $item->classes ) ? array() : (array) $item->classes;
     $class_names = join( ' ', apply_filters( 'nav_menu_css_class', array_filter( $classes ), $item ) );
     $class_names = ' class="'. esc_attr( $class_names ).' '.$parlo_cls . '"';
	 
    if($item->column){
        $this->parlo_CLM = $item->column;
    }
    if($depth ==1){
     $output .= $indent . '<li' . $value . $class_names .'>';
   }else{
     $output .= $indent . '<li' . $value . $class_names .'>';
   }
     $attributes  = ! empty( $item->attr_title ) ? ' title="'  . esc_attr( $item->attr_title ) .'"' : '';
     $attributes .= ! empty( $item->target )     ? ' target="' . esc_attr( $item->target     ) .'"' : '';
     $attributes .= ! empty( $item->xfn )        ? ' rel="'    . esc_attr( $item->xfn        ) .'"' : '';
     $attributes .= ! empty( $item->url )        ? ' href="'   . esc_attr( $item->url        ) .'"' : '';
     $prepend = '';
     $append = '';
     $description  = ! empty( $item->description ) ? '<span>'.esc_attr( $item->description ).'</span>' : '';
    if(isset($item->menuposition)){
      $this->parlo_menupos = $item->menuposition;
    }else{
      $this->parlo_menupos ='';
    }
     $parlo_sv = '';
     $parlo_ico = '';
     $parlo_fico = '';
     $parlo_aspn = '';
     $parlo_bspn = '';
     $parlo_ttlc = '';  
     $parlo_menutag = ''; 
     $parlo_drop = '';
    if($item->ficon){
      $parlo_ico = $item->ficon;
    }
    if( $item->menutag ){
      $menutag_tag = $item->menutag;
    }
    if(isset($menutag_tag)){
      $parlo_menutag ='<span class="parlo-menu-tag">'.esc_html__( $menutag_tag, 'parlo').'</span> ';
      if(empty($menutag_tag)){
        $parlo_menutag = '';
      }
    }
	
     if($depth != 0)
     {
       $description = $append = $prepend = "";
       $parlo_aspn ='<span>';
       $parlo_bspn ='</span>';
     }
     if($item->disablet){
      $parlo_sv=1;
     }
     if(isset($item->shortcode)){
        $fgh = $item->shortcode;
        $this->parlo_scode=$item->shortcode;
     }
     if( $depth ==1 && $parlo_sv!=1){
       $parlo_ttlc='menu_title';
     }elseif( $depth ==1 && $parlo_sv==1){
       $parlo_ttlc='ttl-hd-cls';
     }
    if ( $args->has_children && $depth === 0){
      $parlo_drop = '<i class="fa fa-angle-down"></i>';
    }else{
      $parlo_drop = '';
    }
      if(isset($parlo_ico)){
        $parlo_fico ='<i class="'.$parlo_ico. '"></i>';
        if(empty($parlo_ico)){
          $parlo_fico = '';
        }
      }
      $item_output = $args->before;
      if($parlo_sv!=1){
        $item_output .= '<a'. $attributes .' class="'.$parlo_ttlc.'">';
        $item_output .= $parlo_menutag. $parlo_fico. $parlo_aspn;
        $item_output .= $args->link_before .$prepend.apply_filters( 'the_title', $item->title, $item->ID ).$append;
        $item_output .= $parlo_bspn;
        $item_output .= $description.$args->link_after;
        $item_output .= ' '.$item->subtitle.$parlo_drop.'</a>';
      }else{
       if(isset($item->shortcode) && !empty($fgh)){
          $item_output .= '<a'. $attributes .'>';
          $item_output .= $this->parlo_scode;
          $item_output .= '</a>';
       }
      }
      $item_output .= $args->after;
      $output .= apply_filters( 'walker_nav_menu_start_el', $item_output, $item, $depth, $args );
  }
  public function display_element( $element, &$children_elements, $max_depth, $depth, $args, &$output ) {
      $id_field = $this->db_fields['id'];
        if ( is_object( $args[0] ) ){
           $args[0]->has_children =  !empty ( $children_elements[ $element->$id_field ] ) ;
        }
        parent::display_element( $element, $children_elements, $max_depth, $depth, $args, $output );
  }

	/**
	 * Menu Fallback
	 * =============
	 * If this function is assigned to the wp_nav_menu's fallback_cb variable
	 * and a manu has not been assigned to the theme location in the WordPress
	 * menu manager the function with display nothing to a non-logged in user,
	 * and will add a link to the WordPress menu manager if logged in as an admin.
	 *
	 * @param array $args passed from the wp_nav_menu function.
	 *
	 */
	public static function fallback( $args ) {
		if ( current_user_can( 'manage_options' ) ) {

			extract( $args );

			$fb_output = null;

			if ( $container ) {
				$fb_output = '<' . $container;

				if ( $container_id )
					$fb_output .= ' id="' . $container_id . '"';

				if ( $container_class )
					$fb_output .= ' class="' . $container_class . '"';

				$fb_output .= '>';
			}

			$fb_output .= '<ul';

			if ( $menu_id )
				$fb_output .= ' id="' . $menu_id . '"';

			if ( $menu_class )
				$fb_output .= ' class="' . $menu_class . '"';

			$fb_output .= '>';
			$fb_output .= '<li><a href="' . admin_url( 'nav-menus.php' ) . '">'.esc_attr('Create Menu','parlo').'</a></li>';
			$fb_output .= '</ul>';

			if ( $container )
				$fb_output .= '</' . $container . '>';

			echo $fb_output;
		}
	}
}