<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Parlo_Elementor_Widget_Service extends Widget_Base {

    public function get_name() {
        return 'parlo-service-addons';
    }
    
    public function get_title() {
        return __( 'PL: Service', 'parlo' );
    }

    public function get_icon() {
        return 'eicon-thumbnails-half';
    }

    public function get_categories() {
        return [ 'parlo-category' ];
    }

    protected function _register_controls() {

        $this->start_controls_section(
            'service-conent',
            [
                'label' => __( 'Service', 'parlo' ),
            ]
        );
            $this->add_control(
                'serviceiconty',
                [
                    'label' => esc_html__( 'Service Icon type', 'parlo' ),
                    'type' => Controls_Manager::SELECT,
                    'default' => '2',
                    'options' => [
                        '1' => esc_html__( 'Icon', 'parlo' ),
                        '2' => esc_html__( 'image', 'parlo' ),
                    ],
                ]
            );

            $this->add_control(
                'serviceimage',
                [
                    'label' => __( 'Service image', 'parlo' ),
                    'type' => Controls_Manager::MEDIA,
                    'default' => [
                        'url' => Utils::get_placeholder_image_src(),
                    ],
                    'condition' => [
                        'serviceiconty' => '2',
                    ]
                ]
            );

            $this->add_group_control(
                Group_Control_Image_Size::get_type(),
                [
                    'name' => 'serviceimagesize',
                    'default' => 'large',
                    'separator' => 'none',
                    'condition' => [
                        'serviceiconty' => '2',
                    ]
                ]
            );

            $this->add_control(
                'serviceicon',
                [
                    'label' => __( 'Service icon', 'parlo' ),
                    'type' => Controls_Manager::ICON,
                    'condition' => [
                        'serviceiconty' => '1',
                    ]
                ]
            );

            $this->add_control(
                'servicetitle',
                [
                    'label' => __( 'Service Title', 'parlo' ),
                    'type' => Controls_Manager::TEXT,
                    'placeholder' => __( 'Service Title', 'parlo' ),
                ]
            );

            $this->add_control(
                'servicecontent',
                [
                    'label' => __( 'Service description', 'parlo' ),
                    'type' => Controls_Manager::TEXTAREA,
                    'rows' => 10,
                    'placeholder' => __( 'Type your description here', 'parlo' ),
                ]
            );

        $this->end_controls_section();

        // Slider Button stle
        $this->start_controls_section(
            'service-style-section',
            [
                'label' => esc_html__( 'Style', 'parlo' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
            $this->add_control(
                'heading_service_title',
                [
                    'label' => __( 'Title', 'parlo' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'service_title_typography',
                    'scheme' => Scheme_Typography::TYPOGRAPHY_1,
                    'selector' => '{{WRAPPER}} .single-service .service-content h4',
                ]
            );

            $this->add_control(
                'service_title_color',
                [
                    'label' => __( 'Color', 'parlo' ),
                    'type' => Controls_Manager::COLOR,
                    'scheme' => [
                        'type' => Scheme_Color::get_type(),
                        'value' => Scheme_Color::COLOR_1,
                    ],
                    'default' =>'#383838',
                    'selectors' => [
                        '{{WRAPPER}} .single-service .service-content h4' => 'color: {{VALUE}};',
                        '{{WRAPPER}} .single-service .service-content span' => 'background-color: {{VALUE}};',
                    ],
                ]
            );

            $this->add_control(
                'heading_service_description',
                [
                    'label' => __( 'Description', 'parlo' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'service_desc_typography',
                    'scheme' => Scheme_Typography::TYPOGRAPHY_1,
                    'selector' => '{{WRAPPER}} .single-service .service-content p',
                ]
            );

            $this->add_control(
                'service_desc_color',
                [
                    'label' => __( 'Color', 'parlo' ),
                    'type' => Controls_Manager::COLOR,
                    'scheme' => [
                        'type' => Scheme_Color::get_type(),
                        'value' => Scheme_Color::COLOR_1,
                    ],
                    'default' =>'#383838',
                    'selectors' => [
                        '{{WRAPPER}} .single-service .service-content p' => 'color: {{VALUE}};',
                    ],
                ]
            );

            $this->add_responsive_control(
                'service_content_margin',
                [
                    'label' => __( 'Service Content Padding', 'parlo' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .service-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ]
                ]
            );

        $this->end_controls_section(); // Tab option end

    }

    protected function render( $instance = [] ) {

        $settings   = $this->get_settings_for_display();
        $settings           = $this->get_settings_for_display();
        $serviceiconty      = $this->get_settings_for_display('serviceiconty');
        $servicetitle       = $this->get_settings_for_display('servicetitle');
        $servicecontent     = $this->get_settings_for_display('servicecontent');
        $serviceicon        = $this->get_settings_for_display('serviceicon');
       
        ?>
            <div class="single-service">
                <div class="service-icon">
                    <?php
                        if( $serviceiconty == 2 ){
                            echo Group_Control_Image_Size::get_attachment_image_html( $settings, 'serviceimagesize', 'serviceimage' );
                        }else{
                            echo '<i class="'.esc_attr($serviceicon).'"></i>';
                        }
                    ?>
                </div>
                <div class="service-content">
                    <?php
                        if( !empty($servicetitle) ){
                            echo '<h4>'.esc_attr($servicetitle).'</h4> <span></span>';
                        }
                        if( !empty($servicecontent) ){
                            echo '<p>'.$servicecontent.'</p>';
                        }
                    ?>
                </div>
            </div>
        <?php
    }

}

Plugin::instance()->widgets_manager->register_widget_type( new Parlo_Elementor_Widget_Service() );

