<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Parlo_Elementor_Widget_Latest_Blog extends Widget_Base {

    public function get_name() {
        return 'parlo-latestblog-addons';
    }
    
    public function get_title() {
        return __( 'PL: Blog', 'parlo' );
    }

    public function get_icon() {
        return 'eicon-post-content';
    }

    public function get_categories() {
        return [ 'parlo-category' ];
    }

    protected function _register_controls() {

        $this->start_controls_section(
            'blog-conent',
            [
                'label' => __( 'Blog', 'parlo' ),
            ]
        );

            $this->add_control(
                'blog_grid_style',
                [
                    'label' => esc_html__( 'Layout', 'parlo' ),
                    'type' => Controls_Manager::SELECT,
                    'default' => '1',
                    'options' => [
                        '1' => esc_html__( 'Layout One', 'parlo' ),
                        '2' => esc_html__( 'Layout Two', 'parlo' ),
                    ],
                ]
            );
            
            $this->add_control(
                'blog_grid_column',
                [
                    'label' => esc_html__( 'Columns', 'parlo' ),
                    'type' => Controls_Manager::SELECT,
                    'default' => '2',
                    'options' => [
                        '1' => esc_html__( '1', 'parlo' ),
                        '2' => esc_html__( '2', 'parlo' ),
                        '3' => esc_html__( '3', 'parlo' ),
                        '4' => esc_html__( '4', 'parlo' ),
                        '5' => esc_html__( '5', 'parlo' ),
                        '6' => esc_html__( '6', 'parlo' ),
                    ],
                ]
            );

            $this->add_control(
                'categories',
                [
                    'label' => esc_html__( 'Categories', 'parlo' ),
                    'type' => Controls_Manager::SELECT2,
                    'label_block' => true,
                    'multiple' => true,
                    'options' => parlo_get_taxonomies(),
                    'separator'=>'before',
                ]
            );

            $this->add_control(
                'post_limit',
                [
                    'label' => __('Limit', 'parlo'),
                    'type' => Controls_Manager::NUMBER,
                    'default' => 2,
                    'separator'=>'before',
                ]
            );

            $this->add_control(
                'custom_order',
                [
                    'label' => esc_html__( 'Custom order', 'parlo' ),
                    'type' => Controls_Manager::SWITCHER,
                    'return_value' => 'yes',
                    'default' => 'no',
                ]
            );

            $this->add_control(
                'postorder',
                [
                    'label' => esc_html__( 'Order', 'parlo' ),
                    'type' => Controls_Manager::SELECT,
                    'default' => 'DESC',
                    'options' => [
                        'DESC'  => esc_html__('Descending','parlo'),
                        'ASC'   => esc_html__('Ascending','parlo'),
                    ],
                    'condition' => [
                        'custom_order!' => 'yes',
                    ]
                ]
            );

            $this->add_control(
                'orderby',
                [
                    'label' => esc_html__( 'Orderby', 'parlo' ),
                    'type' => Controls_Manager::SELECT,
                    'default' => 'none',
                    'options' => [
                        'none'          => esc_html__('None','parlo'),
                        'ID'            => esc_html__('ID','parlo'),
                        'date'          => esc_html__('Date','parlo'),
                        'name'          => esc_html__('Name','parlo'),
                        'title'         => esc_html__('Title','parlo'),
                        'comment_count' => esc_html__('Comment count','parlo'),
                        'rand'          => esc_html__('Random','parlo'),
                    ],
                    'condition' => [
                        'custom_order' => 'yes',
                    ]
                ]
            );

            $this->add_control(
                'title_len',
                [
                    'label' => __('Title Length', 'parlo'),
                    'type' => Controls_Manager::NUMBER,
                    'default' => 5,
                ]
            );

            $this->add_control(
                'content_len',
                [
                    'label' => __('Content Length', 'parlo'),
                    'type' => Controls_Manager::NUMBER,
                    'default' => 35,
                ]
            );

        $this->end_controls_section();

        // Slider Button stle
        $this->start_controls_section(
            'blog-style-section',
            [
                'label' => esc_html__( 'Style', 'parlo' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
            $this->add_control(
                'heading_blog_title',
                [
                    'label' => __( 'Title', 'parlo' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'blog_title_typography',
                    'scheme' => Scheme_Typography::TYPOGRAPHY_1,
                    'selector' => '{{WRAPPER}} .blog-content h2 a',
                ]
            );

            $this->add_control(
                'blog_title_color',
                [
                    'label' => __( 'Color', 'parlo' ),
                    'type' => Controls_Manager::COLOR,
                    'scheme' => [
                        'type' => Scheme_Color::get_type(),
                        'value' => Scheme_Color::COLOR_1,
                    ],
                    'default' =>'#1f2226',
                    'selectors' => [
                        '{{WRAPPER}} .blog-content h2 a' => 'color: {{VALUE}};',
                    ],
                ]
            );

            $this->add_control(
                'blog_title_hover_color',
                [
                    'label' => __( 'Hover Color', 'parlo' ),
                    'type' => Controls_Manager::COLOR,
                    'scheme' => [
                        'type' => Scheme_Color::get_type(),
                        'value' => Scheme_Color::COLOR_1,
                    ],
                    'default' =>'#ff3535',
                    'selectors' => [
                        '{{WRAPPER}} .blog-content h2 a:hover' => 'color: {{VALUE}};',
                    ],
                ]
            );

            $this->add_control(
                'heading_blog_content',
                [
                    'label' => __( 'Content', 'parlo' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                ]
            );

            $this->add_control(
                'blog_content_color',
                [
                    'label' => __( 'Color', 'parlo' ),
                    'type' => Controls_Manager::COLOR,
                    'scheme' => [
                        'type' => Scheme_Color::get_type(),
                        'value' => Scheme_Color::COLOR_1,
                    ],
                    'default' =>'#1f2226',
                    'selectors' => [
                        '{{WRAPPER}} .blog-content p' => 'color: {{VALUE}};',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'blog_content_typography',
                    'scheme' => Scheme_Typography::TYPOGRAPHY_1,
                    'selector' => '{{WRAPPER}} .blog-content p',
                ]
            );

            $this->add_control(
                'heading_blog_meta',
                [
                    'label' => __( 'Meta Info', 'parlo' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'blog_meta_typography',
                    'scheme' => Scheme_Typography::TYPOGRAPHY_1,
                    'selector' => '{{WRAPPER}} .blog-content ul.mata-info li a,{{WRAPPER}} .blog-content ul.mata-info li',
                ]
            );

            $this->add_control(
                'blog_meta_color',
                [
                    'label' => __( 'Color', 'parlo' ),
                    'type' => Controls_Manager::COLOR,
                    'scheme' => [
                        'type' => Scheme_Color::get_type(),
                        'value' => Scheme_Color::COLOR_1,
                    ],
                    'default' =>'#919090',
                    'selectors' => [
                        '{{WRAPPER}} .blog-content ul.mata-info li a' => 'color: {{VALUE}};',
                        '{{WRAPPER}} .blog-content ul.mata-info li' => 'color: {{VALUE}};',
                        '{{WRAPPER}} .blog-content ul.mata-info li:after' => 'background-color: {{VALUE}};',
                    ],
                ]
            );

        $this->end_controls_section(); // Tab option end

    }

    protected function render( $instance = [] ) {

        $settings   = $this->get_settings_for_display();
        $custom_order_ck    = $this->get_settings_for_display('custom_order');
        $orderby            = $this->get_settings_for_display('orderby');
        $postorder          = $this->get_settings_for_display('postorder');
        $columns            = $this->get_settings_for_display('blog_grid_column');

        // Query
        $args = array(
            'post_type'             => 'post',
            'post_status'           => 'publish',
            'ignore_sticky_posts'   => 1,
            'posts_per_page'        => !empty( $settings['post_limit'] ) ? $settings['post_limit'] : 2,
            'order'                 => $postorder
        );

        // Custom Order
        if( $custom_order_ck == 'yes' ){
            $args['orderby']    = $orderby;
        }

        $get_categories = $settings['categories'];

        $grid_cats = str_replace(' ', '', $get_categories);

        if (  !empty( $get_categories ) ) {
            if( is_array($grid_cats) && count($grid_cats) > 0 ){
                $field_name = is_numeric( $grid_cats[0] ) ? 'term_id' : 'slug';
                $args['tax_query'] = array(
                    array(
                        'taxonomy' => 'category',
                        'terms' => $grid_cats,
                        'field' => $field_name,
                        'include_children' => false
                    )
                );
            }
        }

        $latest_post = new \WP_Query( $args );

        $collumval = 'ht-col-xs-12 ht-col-md-6 blog-style-'.$settings['blog_grid_style'];
        if( $columns != '' ){
            $colwidth = round( 12/$columns );
            $collumval = 'ht-col-xs-12 ht-col-md-'.$colwidth.' ht-col-sm-'.$colwidth.' blog-style-'.$settings['blog_grid_style'];
        }
       
        ?>
            <div class="latest-blog-area">
                <div class="ht-row">
                    <?php
                        $i=0;
                        if( $latest_post->have_posts() ):
                            while( $latest_post->have_posts() ) : $latest_post->the_post();
                                $i++;
                    ?>

                    <div class="<?php echo $collumval; if( $i%2 == 0 ){ echo ' space_left'; } ?>">
                        <div class="single-blog">
                            <div class="thumb">
                                <a href="<?php the_permalink(); ?>">
                                    <?php the_post_thumbnail( 'parlo_size_550x350' ); ?>
                                </a>
                            </div>
                            <div class="blog-content">
                                <h2><a href="<?php the_permalink(); ?>"><?php echo wp_trim_words( get_the_title(), $settings['title_len'], ' ' ); ?></a></h2>
                                <ul class="mata-info">
                                    <li><?php echo get_the_time( get_option('date_format') ); ?></li>
                                    <?php 
                                        if( function_exists('parloGetPostViews') ){
                                            if( parloGetPostViews( get_the_ID() ) > 1 ){
                                                echo '<li><a href="#">'.parloGetPostViews( get_the_ID() ).esc_html__(' Views','parlo').'</a></li>'; 
                                            }else{
                                                echo '<li><a href="#">'.parloGetPostViews( get_the_ID() ).esc_html__(' View','parlo').'</a></li>'; 
                                            }
                                        } 
                                    ?>
                                    <?php
                                        if( function_exists( 'parlo_getPostLikeLink' ) ){
                                            echo '<li>'.parlo_getPostLikeLink( get_the_ID() ).'</li>';
                                        }
                                    ?>
                                </ul>
                                <?php
                                    if( $settings['content_len'] > 0 ){
                                        echo '<p>'.wp_trim_words( get_the_content(), $settings['content_len'], ' ' ).'</p>'; 
                                    }
                                ?>
                            </div>
                        </div>
                    </div>

                    <?php endwhile; endif; wp_reset_postdata(); wp_reset_query(); ?>
                </div>
                
            </div>
        <?php
    }

}

Plugin::instance()->widgets_manager->register_widget_type( new Parlo_Elementor_Widget_Latest_Blog() );

