<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Parlo_Elementor_Widget_Add_Banner extends Widget_Base {

    public function get_name() {
        return 'parlo-addbanner-addons';
    }
    
    public function get_title() {
        return __( 'PL: Add Banner', 'parlo' );
    }

    public function get_icon() {
        return 'eicon-insert-image';
    }

    public function get_categories() {
        return [ 'parlo-category' ];
    }

    protected function _register_controls() {

        $this->start_controls_section(
            'banner-conent',
            [
                'label' => __( 'Banner', 'parlo' ),
            ]
        );

        $this->end_controls_section();

        // Slider Button stle
        $this->start_controls_section(
            'banner-style-section',
            [
                'label' => esc_html__( 'Style', 'parlo' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
           
        $this->end_controls_section(); // Tab option end

    }

    protected function render( $instance = [] ) {

        $settings   = $this->get_settings_for_display();
       
        ?>
            <div class="woolentor-banner">
                
            </div>
        <?php
    }

}

Plugin::instance()->widgets_manager->register_widget_type( new Parlo_Elementor_Widget_Add_Banner() );

