<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Parlo_Elementor_Widget_Woo_Collection extends Widget_Base {

    public function get_name() {
        return 'parlo-collection';
    }
    
    public function get_title() {
        return __( 'PL: Collection', 'parlo' );
    }

    public function get_icon() {
        return 'eicon-photo-library';
    }
    public function get_categories() {
        return [ 'parlo-category' ];
    }

    protected function _register_controls() {

        $this->start_controls_section(
            'collection_setting',
            [
                'label' => esc_html__( 'Collection', 'parlo' ),
            ]
        );

            $this->add_control(
                'select_category_type',
                [
                    'label' => esc_html__( 'Select Category Type', 'parlo' ),
                    'type' => Controls_Manager::SELECT,
                    'default' => 'all_cat',
                    'options' => [
                        'single_cat'          => esc_html__('Single Category','parlo'),
                        'multiple_cat'        => esc_html__('Multiple Category','parlo'),
                        'all_cat'             => esc_html__('All Category','parlo'),
                    ],
                ]
            );

            $this->add_control(
                'category_grid_column',
                [
                    'label' => esc_html__( 'Columns', 'parlo' ),
                    'type' => Controls_Manager::SELECT,
                    'default' => '3',
                    'options' => [
                        '1' => esc_html__( 'One', 'parlo' ),
                        '2' => esc_html__( 'Two', 'parlo' ),
                        '3' => esc_html__( 'Three', 'parlo' ),
                        '4' => esc_html__( 'Four', 'parlo' ),
                        '5' => esc_html__( 'Five', 'parlo' ),
                        '6' => esc_html__( 'Six', 'parlo' ),
                    ],
                ]
            );

            $this->add_control(
                'parlo_product_categories',
                [
                    'label' => esc_html__( 'Select categories', 'parlo' ),
                    'type' => Controls_Manager::SELECT2,
                    'label_block' => true,
                    'options' => parlo_get_taxonomies( 'product_cat' ),
                    'condition' => [
                        'select_category_type' => 'single_cat',
                    ]
                ]
            );

            $this->add_control(
                'parlo_product_multi_categories',
                [
                    'label' => esc_html__( 'Select categories', 'parlo' ),
                    'type' => Controls_Manager::SELECT2,
                    'label_block' => true,
                    'multiple' => true,
                    'options' => parlo_get_taxonomies( 'product_cat' ),
                    'condition' => [
                        'select_category_type' => 'multiple_cat',
                    ]
                ]
            );

            $this->add_control(
                'catorder',
                [
                    'label' => esc_html__( 'Order', 'parlo' ),
                    'type' => Controls_Manager::SELECT,
                    'default' => 'ASC',
                    'options' => [
                        'ASC'   => esc_html__('Ascending','parlo'),
                        'DESC'  => esc_html__('Descending','parlo'),
                    ],
                    'condition' => [
                        'select_category_type' => 'multiple_cat',
                    ]
                ]
            );

            $this->add_control(
                'limitcount',
                [
                    'label' => esc_html__( 'Show items', 'parlo' ),
                    'type' => Controls_Manager::NUMBER,
                    'min' => 1,
                    'max' => 10,
                    'step' => 1,
                    'default' => 5,
                    'condition' => [
                        'select_category_type' => 'all_cat',
                    ]
                ]
            );

            $this->add_control(
                'custom_title',
                [
                    'label' => esc_html__( 'Custom Title', 'parlo' ),
                    'type' => Controls_Manager::SWITCHER,
                    'return_value' => 'yes',
                    'default' => 'no',
                    'condition' => [
                        'select_category_type' => 'single_cat',
                    ]
                ]
            );

            $this->add_control(
                'catcustitle',
                [
                    'label' => __( 'Title', 'parlo' ),
                    'type' => Controls_Manager::TEXT,
                    'rows' => 10,
                    'placeholder' => __( 'Type your title here', 'parlo' ),
                    'condition' => [
                        'custom_title' => 'yes',
                    ]
                ]
            );

            $this->add_control(
                'custom_image',
                [
                    'label' => esc_html__( 'Custom Image', 'parlo' ),
                    'type' => Controls_Manager::SWITCHER,
                    'return_value' => 'yes',
                    'default' => 'no',
                    'condition' => [
                        'select_category_type' => 'single_cat',
                    ]
                ]
            );

            $this->add_control(
                'catcusimage',
                [
                    'label' => __( 'Image', 'parlo' ),
                    'type' => Controls_Manager::MEDIA,
                    'default' => [
                        'url' => Utils::get_placeholder_image_src(),
                    ],
                    'condition' => [
                        'custom_image' => 'yes',
                    ]
                ]
            );

            $this->add_group_control(
                Group_Control_Image_Size::get_type(),
                [
                    'name' => 'catcusimagesize',
                    'default' => 'large',
                    'separator' => 'none',
                    'condition' => [
                        'custom_image' => 'yes',
                    ]
                ]
            );

        $this->end_controls_section();

        // Title Style tab section
        $this->start_controls_section(
            'cullenstion_title_styles',
            [
                'label' => __( 'Title style', 'parlo' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

            $this->start_controls_tabs(
                'cullection_title_style_tabs'
            );

                $this->start_controls_tab(
                    'cullection_title_style_normal_tab',
                    [
                        'label' => __( 'Normal', 'parlo' ),
                    ]
                );

                    $this->add_control(
                        'cullection_title_color',
                        [
                            'label' => __( 'Color', 'parlo' ),
                            'type' => Controls_Manager::COLOR,
                            'scheme' => [
                                'type' => Scheme_Color::get_type(),
                                'value' => Scheme_Color::COLOR_1,
                            ],
                            'default' =>'#1f2226',
                            'selectors' => [
                                '{{WRAPPER}} .single-collection .collection-title' => 'color: {{VALUE}};',
                            ],
                        ]
                    );

                $this->end_controls_tab();// Normal tab end

                $this->start_controls_tab(
                    'cullection_title_style_hover_tab',
                    [
                        'label' => __( 'Hover', 'parlo' ),
                    ]
                );
                    $this->add_control(
                        'cullection_hover_title_color',
                        [
                            'label' => __( 'Color', 'parlo' ),
                            'type' => Controls_Manager::COLOR,
                            'scheme' => [
                                'type' => Scheme_Color::get_type(),
                                'value' => Scheme_Color::COLOR_1,
                            ],
                            'default' =>'#ff3535',
                            'selectors' => [
                                '{{WRAPPER}} .single-collection .collection-title:hover' => 'color: {{VALUE}};',
                            ],
                        ]
                    );

                $this->end_controls_tab();// Hover tab end

            $this->end_controls_tabs();

        $this->end_controls_section();

    }

    protected function render( $instance = [] ) {

        $settings = $this->get_settings_for_display();
        $select_category_type = $this->get_settings_for_display('select_category_type');
        $order = ! empty( $settings['catorder'] ) ? $settings['catorder'] : '';

        $custom_title   = $this->get_settings_for_display('custom_title');
        $custom_image   = $this->get_settings_for_display('custom_image');
        $catcustitle    = $this->get_settings_for_display('catcustitle');
        $columns        = $this->get_settings_for_display('category_grid_column');

        $collumval = 'col-lg-4 col-md-6';
        if( $columns !='' ){
            if( $columns == 5){
                $collumval = 'cus-col-5';
            }else{
                $colwidth = round( 12/$columns );
                $collumval = 'col-lg-'.$colwidth.' col-md-6 col-12';
            }
        }

        $catargs = array(
            'orderby'    => 'name',
            'order'      => $order,
            'hide_empty' => true,
        );

        if( $select_category_type == 'single_cat' ){
            $product_categories = $settings['parlo_product_categories'];
            $product_cats = str_replace(' ', '', $product_categories);
            $catargs['slug'] = $product_cats;
        }
        elseif( $select_category_type == 'multiple_cat' ){
            $product_categories = $settings['parlo_product_multi_categories'];
            $product_cats = str_replace(' ', '', $product_categories);
            $catargs['slug'] = $product_cats;
        }else{
            $catargs['slug'] = '';
        }
        $prod_categories = get_terms( 'product_cat', $catargs);

        if( $select_category_type == 'all_cat' ){
            $limitcount = $settings['limitcount'];
        }else{
            $limitcount = -1;
        }

        
            if( $select_category_type != 'single_cat' ){ echo '<div class="collection-wrap"><div class="row">'; }

                $cb=0;
                foreach( $prod_categories as $prod_cat ) :
                    $cb++;
                    
                    $cat_thumb_id = get_woocommerce_term_meta( $prod_cat->term_id, 'thumbnail_id', true );
                    $cat_thumb_url = wp_get_attachment_image_src( $cat_thumb_id,'full' );
                    $term_link = get_term_link( $prod_cat, 'product_cat' );

                    if( ( $custom_title == 'yes' ) && ( !empty( $catcustitle ) ) ){
                        $prod_cat->name = $catcustitle;
                    }

                    if( ( $custom_image == 'yes' ) && ( !empty($settings['catcusimage']['url']) ) ){
                        $cat_thumb_url[0] = $settings['catcusimage']['url'];
                    }

                ?>

                    <!-- single-brand-product start -->
                    <?php if( $select_category_type != 'single_cat' ){ echo '<div class="'.$collumval.'">'; } ?>
                        <div class="single-collection <?php if( empty( $cat_thumb_url[0] ) ){ echo 'no-images'; } ?>">
                            <a href="<?php echo esc_url( $term_link ); ?>">
                                <?php if( !empty($cat_thumb_url[0]) ):?>
                                    <?php 
                                        if( $custom_image == 'yes' ){
                                            echo '<div class="collection-image">'.Group_Control_Image_Size::get_attachment_image_html( $settings, 'catcusimagesize', 'catcusimage' ).'</div>';
                                        }else{
                                    ?>
                                    <div class="collection-image">
                                        <img src="<?php echo esc_url($cat_thumb_url[0]); ?>" alt="<?php echo $prod_cat->name; ?>">
                                    </div>
                                <?php } endif;?>
                                <h3 class="collection-title"><?php echo $prod_cat->name; ?></h3>
                            </a>
                        </div>
                    <?php if( $select_category_type != 'single_cat' ){ echo '</div>'; } ?>
                    <!-- single-category end -->
                    <?php
                    if( $cb == $limitcount ) {
                        break;
                    }

                endforeach;

            if( $select_category_type != 'single_cat' ){ echo '</div></div>'; }

    }

}

Plugin::instance()->widgets_manager->register_widget_type( new Parlo_Elementor_Widget_Woo_Collection() );

