<?php
/**
 * Plugin Name: Parlo Core
 * Plugin URI: https://hasthemes.com
 * Description: After install the Parlo WordPress Theme, you must need to install this "Parlo Core Plugin" first to get all functions of Parlo WP Theme.
 * Version: 1.0.0
 * Author: HasTech
 * Author URI: http://hastech.company
 * Text Domain: HasTech
 * License: GPL/GNU.

/**
* Define Constant
*/
define('PARLO_PLUGINS_DIR', dirname(__FILE__));
define('PARLO_PLUGINS_URL', plugin_dir_url(__FILE__));
define('PARLO_PLUGINS_PATH', plugin_dir_path( __FILE__ ) );

/**----------------------------------------------------------------*/
/* Include all file
/*-----------------------------------------------------------------*/  
include_once( PARLO_PLUGINS_PATH. '/include/helpers_function.php' );
include_once( PARLO_PLUGINS_PATH. '/include/post-like.php' );
include_once( PARLO_PLUGINS_PATH. '/include/menu/parlo_menu.php' );
include_once( PARLO_PLUGINS_PATH. '/include-file.php' );

/**
 * Load Currency
 */
require PARLO_PLUGINS_PATH . '/include/currency/init.php';
require PARLO_PLUGINS_PATH . '/include/widgets/currency_widgets.php';

//Slider Post template
function parlo_canvas_template( $single_template ) {
    global $post;
    if ( 'parlo_slider' == $post->post_type ) {
        $elementor_2_0_canvas = ELEMENTOR_PATH . '/modules/page-templates/templates/canvas.php';
        if ( file_exists( $elementor_2_0_canvas ) ) {
            return $elementor_2_0_canvas;
        } else {
            return ELEMENTOR_PATH . '/includes/page-templates/canvas.php';
        }
    }
    return $single_template;
}
add_filter( 'single_template', 'parlo_canvas_template' );

// Admin Assests CSS
if( !function_exists('parlo_media_scripts') ) {
    function parlo_media_scripts() {
        
        wp_enqueue_style( 'parlo-admin-css', PARLO_PLUGINS_URL . 'assets/css/admin-style.css', false, '1.0.0' );
        
        // wp core styles
        wp_enqueue_style( 'wp-jquery-ui-dialog' );
        // wp core scripts
        wp_enqueue_script( 'jquery-ui-dialog' );

    }
}
add_action('admin_enqueue_scripts', 'parlo_media_scripts');