<?php

//Elementor create category
function parlo_elementor_category ( $elements_manager ) {
    $elements_manager->add_category(
        'parlo-category',
        array(
            'title' => __('Parlo','parlo' ),
            'icon'  => 'fonts',
        )
    );
}
add_action( 'elementor/elements/categories_registered', 'parlo_elementor_category' );

/**
 * Get Post List
 * return array
 */
function parlo_post_name( $post_type = 'post' ){
    $options = array();
    $options['0'] = __('Select','hasthemes');
    $all_post = array( 'posts_per_page' => -1, 'post_type'=> $post_type );
    $post_terms = get_posts( $all_post );
    if ( ! empty( $post_terms ) && ! is_wp_error( $post_terms ) ){
        foreach ( $post_terms as $term ) {
            $options[ $term->ID ] = $term->post_title;
        }
        return $options;
    }
}

/*
 * Get Taxonomy
 * return array
 */
function parlo_get_taxonomies( $texonomy = 'category' ){
    $terms = get_terms( array(
        'taxonomy' => $texonomy,
        'hide_empty' => true,
    ));
    if ( ! empty( $terms ) && ! is_wp_error( $terms ) ){
        foreach ( $terms as $term ) {
            $options[ $term->slug ] = $term->name;
        }
        return $options;
    }
}

/*
 * Get Post Counter
 * return number
 */
function parloGetPostViews( $postID ){
    $count_key = 'post_views_count';
    $count = get_post_meta($postID, $count_key, true);
    if($count==''){
        delete_post_meta($postID, $count_key);
        add_post_meta( $postID, $count_key, '0' );
        return "0";
    }
    return $count;
}
 
/*
 * Set Post Counter
 * return number
 */
function parloSetPostViews( $postID ) {
    $count_key = 'post_views_count';
    $count = get_post_meta( $postID, $count_key, true );
    if( $count=='' ){
        $count = 0;
        delete_post_meta( $postID, $count_key );
        add_post_meta( $postID, $count_key, '0' );
    }else{
        $count++;
        update_post_meta($postID, $count_key, $count);
    }
}

/*
 * Social Share
 */
function parlo_get_social_share_html( $id ){

    $facebook_url = 'https://www.facebook.com/sharer/sharer.php?u='. get_the_permalink( $id );
    $twitter_url = 'https://twitter.com/share?'. esc_url( get_permalink( $id ) ) .'&amp;text='. get_the_title( $id );
    $google_plus_url = 'https://plus.google.com/share?url='. esc_url(get_permalink( $id ));
    $linkedin_url = 'http://www.linkedin.com/shareArticle?url='. esc_url(get_permalink( $id )) .'&amp;title='. get_the_title( $id );

    $social_share_html = '<div class="blog-share">';
    $social_share_html .= '<span>'.esc_html__('Share :','parlo').'</span>';
    $social_share_html .= '<div class="share-social">';
    $social_share_html .= '<ul>';
    $social_share_html .= '<li><a class="facebook" href="'.esc_url( $facebook_url ).'"><i class="sli sli-social-facebook"></i></a></li>';
    $social_share_html .= '<li><a class="twitter" href="'.esc_url( $twitter_url ).'"><i class="sli sli-social-twitter"></i></a></li>';
    $social_share_html .= '<li><a class="google" href="'.esc_url( $google_plus_url ).'"><i class="sli sli-social-google"></i></a></li>';
    $social_share_html .= '<li><a class="linkedin" href="'.esc_url( $linkedin_url ).'"><i class="sli sli-social-linkedin"></i></a></li>';
    $social_share_html .= '</ul>';
    $social_share_html .= '</div>';
    $social_share_html .= '</div>';

    return $social_share_html;
}