<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Parlo_Elementor_Widget_TeamMember extends Widget_Base {

    public function get_name() {
        return 'parlo-teammember-addons';
    }
    
    public function get_title() {
        return __( 'PL: Team Member', 'parlo' );
    }

    public function get_icon() {
        return 'fa fa-user';
    }

    public function get_categories() {
        return [ 'parlo-category' ];
    }

    protected function _register_controls() {

        $this->start_controls_section(
            'teammember-conent',
            [
                'label' => __( 'Team Member', 'parlo' ),
            ]
        );

            $this->add_control(
                'memberimage',
                [
                    'label' => __( 'Team Member Image', 'parlo' ),
                    'type' => Controls_Manager::MEDIA,
                    'default' => [
                        'url' => Utils::get_placeholder_image_src(),
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Image_Size::get_type(),
                [
                    'name' => 'memberimagesize',
                    'default' => 'large',
                    'separator' => 'none',
                ]
            );

            $this->add_control(
                'team_member_name',
                [
                    'label' => __( 'Name', 'parlo' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => __('Mr.Mike Banding','parlo'),
                ]
            );

            $this->add_control(
                'team_member_designation',
                [
                    'label' => __( 'Designation', 'parlo' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => __('Developer','parlo'),
                ]
            );

        $this->end_controls_section();

        // Social Media
        $this->start_controls_section(
            'teammember-social-media',
            [
                'label' => __( 'Social Media', 'parlo' ),
            ]
        );
            $repeater = new Repeater();

            $repeater->add_control(
                'team_member_profile_url',
                [
                    'label'   => __( 'Social Media Link', 'parlo' ),
                    'type'    => Controls_Manager::TEXT,
                    'default' => __('#','parlo'),
                ]
            );

            $repeater->add_control(
                'team_member_social_media_icon',
                [
                    'label'   => __( 'Designation', 'parlo' ),
                    'type' => Controls_Manager::ICON,
                    'default' => 'fa fa-facebook',
                ]
            );

            $repeater->add_control(
                'social_media_color',
                [
                    'label'     => __( 'Color', 'parlo' ),
                    'type'      => Controls_Manager::COLOR,
                    'scheme'    => [
                        'type'  => Scheme_Color::get_type(),
                        'value' => Scheme_Color::COLOR_2,
                    ],
                    'default'   => '#ffffff',
                    'selectors' => [
                        '{{WRAPPER}} .team-wrapper .team-img .team-action {{CURRENT_ITEM}}' => 'color: {{VALUE}}',
                    ],
                    'separator' => 'before',
                ]
            );

            $repeater->add_control(
                'social_media_bg_color',
                [
                    'label'     => __( 'Background Color', 'parlo' ),
                    'type'      => Controls_Manager::COLOR,
                    'scheme'    => [
                        'type'  => Scheme_Color::get_type(),
                        'value' => Scheme_Color::COLOR_4,
                    ],
                    'default'   => '#3b5998',
                    'selectors' => [
                        '{{WRAPPER}} .team-wrapper .team-img .team-action {{CURRENT_ITEM}}' => 'background-color: {{VALUE}}',
                    ],
                    'separator' => 'before',
                ]
            );

            $this->add_control(
                'teammember_social_list',
                [
                    'type'    => Controls_Manager::REPEATER,
                    'fields'  => array_values( $repeater->get_controls() ),
                    'default' => [
                        [
                            'team_member_profile_url' => __('#','parlo'),
                            'team_member_social_media_icon'  => 'fa fa-facebook',
                        ],
                        [
                            'team_member_profile_url' => __('#','parlo'),
                            'team_member_social_media_icon'  => 'fa fa-twitter',
                        ],
                        [
                            'team_member_profile_url' => __('#','parlo'),
                            'team_member_social_media_icon'  => 'fa fa-instagram',
                        ],
                    ]
                ]
            );

        $this->end_controls_section();

        // Style Section
        $this->start_controls_section(
            'team-style-section',
            [
                'label' => esc_html__( 'Style', 'parlo' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
            
            $this->add_control(
                'team_member_item_area_bg_color',
                [
                    'label' => __( 'Area Background Color', 'plugin-domain' ),
                    'type' => Controls_Manager::COLOR,
                    'scheme' => [
                        'type' => Scheme_Color::get_type(),
                        'value' => Scheme_Color::COLOR_1,
                    ],
                    'default'   => '#f7f7f7',
                    'selectors' => [
                        '{{WRAPPER}} .team-wrapper' => 'background-color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_control(
                'team_name_color',
                [
                    'label' => __( 'Name Color', 'plugin-domain' ),
                    'type' => Controls_Manager::COLOR,
                    'scheme' => [
                        'type' => Scheme_Color::get_type(),
                        'value' => Scheme_Color::COLOR_1,
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .team-wrapper .team-content h4' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_control(
                'team_designation_color',
                [
                    'label' => __( 'Designation Color', 'plugin-domain' ),
                    'type' => Controls_Manager::COLOR,
                    'scheme' => [
                        'type' => Scheme_Color::get_type(),
                        'value' => Scheme_Color::COLOR_1,
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .team-wrapper .team-content span' => 'color: {{VALUE}}',
                    ],
                ]
            );

        $this->end_controls_section(); // Style Section

    }

    protected function render( $instance = [] ) {

        $settings   = $this->get_settings_for_display();
       
        ?>
            <div class="team-wrapper">
                <div class="team-img">
                    <?php echo Group_Control_Image_Size::get_attachment_image_html( $settings, 'memberimagesize', 'memberimage' );?>

                    <?php if( $settings['teammember_social_list'] ):?>
                        <div class="team-action">
                            <?php foreach ( $settings['teammember_social_list'] as $socialmedia ) :?>
                                <a class="elementor-repeater-item-<?php echo $socialmedia['_id']; ?>" href="<?php echo esc_url( $socialmedia['team_member_profile_url'] ); ?>">
                                    <i class="<?php echo esc_attr( $socialmedia['team_member_social_media_icon'] ); ?>"></i>
                                </a>
                            <?php endforeach; ?>
                        </div>
                    <?php endif; ?>

                </div>
                <div class="team-content text-center">
                    <?php
                        if( !empty( $settings['team_member_name'] ) ){
                            echo '<h4>'.esc_html( $settings['team_member_name'] ).'</h4>';
                        }
                        if( !empty( $settings['team_member_designation'] ) ){
                            echo '<span>'.esc_html( $settings['team_member_designation'] ).'</span>';
                        }
                    ?>
                </div>
            </div>
        <?php
    }

}

Plugin::instance()->widgets_manager->register_widget_type( new Parlo_Elementor_Widget_TeamMember() );

